<?php
class XMLCreator
{
	var $handle = NULL;
	
	public function __construct()
	{
		$this->handle = new DOMDocument('1.0','UTF-8');
		
	}
	
	public function createErrorData($arrData)
	{
		if(is_array($arrData))
		{
			$arrCount = count($arrData);
			if($arrCount > 0)
			{
				$root = $this->handle->createElement("ERROR");
				$this->handle->appendChild($root);
				
				$id = $this->handle->createElement("errorNumber");						
				$idText = $this->handle->createTextNode($arrData['errorNo']);
				$id->appendChild($idText);
						
				$name = $this->handle->createElement("errorMessage");						
				$nameText = $this->handle->createTextNode($arrData['errorMessage']);
				$name->appendChild($nameText);
				
				$root->appendChild($id);
				$root->appendChild($name);
				
				return TRUE;
					
			}
			else
			{
				return NULL;
			}
		}
		else
		{
			return NULL;
		}
	}
	
	public function createPaymentSuccessData($arrData)
	{
		if(is_array($arrData))
		{
			$arrCount = count($arrData);
			if($arrCount > 0)
			{
				$root = $this->handle->createElement("SUCCESS");
				$this->handle->appendChild($root);
				
				$id = $this->handle->createElement("ReceiptNumber");						
				$idText = $this->handle->createTextNode($arrData['No']);
				$id->appendChild($idText);
						
				$name = $this->handle->createElement("Message");						
				$nameText = $this->handle->createTextNode($arrData['Message']);
				$name->appendChild($nameText);
				
				$root->appendChild($id);
				$root->appendChild($name);
				
				return TRUE;
					
			}
			else
			{
				return NULL;
			}
		}
		else
		{
			return NULL;
		}
	}
	public  function createInvoiceData($arrData)
	{
		
		if(is_array($arrData))
		{
			$arrCount = count($arrData);
			if($arrCount > 0)
			{
					for($i=0;$i<$arrCount;$i++)
					{
						if(is_array($arrData['Invoice']) && count($arrData['Invoice']) > 0)
						{
							$invdata = $arrData['Invoice'][$i];
							//print_r($invdata);exit;
							
							$root = $this->handle->createElement("BILL");
							$this->handle->appendChild($root);
							
							$id = $this->handle->createElement("ID");						
							$idText = $this->handle->createTextNode($invdata['CashierBiller']);
							$id->appendChild($idText);
							
							$CashierBiller = $this->handle->createElement("CashierBiller");
							$CashierBiller->appendChild($id);		
							
							$id = $this->handle->createElement("ID");						
							$idText = $this->handle->createTextNode($invdata['PatientID']);
							$id->appendChild($idText);
							
							$name = $this->handle->createElement("Name");						
							$nameText = $this->handle->createTextNode($invdata['PatName']);
							$name->appendChild($nameText);
							
							$pstatus = $this->handle->createElement("Status");						
							$pstatusText = $this->handle->createTextNode($invdata['PatStatus']);
							$pstatus->appendChild($pstatusText);
							
							$patient = $this->handle->createElement("Patient");
							$patient->appendChild($id);
							$patient->appendChild($name);	
							$patient->appendChild($pstatus);
							
							$outbill = $this->handle->createElement("Amount");						
							$outbillText = $this->handle->createTextNode(number_format($invdata['OutBill'],2));
							$outbill->appendChild($outbillText);
							
							$outbillTag = $this->handle->createElement("OustandingBill");
							$outbillTag->appendChild($outbill);
							
							$invNumber = $this->handle->createElement("Number");
							$invNumberText = $this->handle->createTextNode($invdata['InvoiceNo']);
							$invNumber->appendChild($invNumberText);
						
							$invCurrency = $this->handle->createElement("Currency");
							$invCurrencyText = $this->handle->createTextNode("GHC");
							$invCurrency->appendChild($invCurrencyText);
							
							$invAmount= $this->handle->createElement("TotalAmount");
							$invAmountText = $this->handle->createTextNode(number_format($invdata['InvoiceAmt'],2));
							$invAmount->appendChild($invAmountText);
							
							$invDateTime = $this->handle->createElement("DateTime");
							$invDateTimeText = $this->handle->createTextNode($invdata['InvoiceTime']->format('d-m-Y H:i:s'));
							$invDateTime->appendChild($invDateTimeText);
						
							
							$invoice = $this->handle->createElement("Invoice");
							$invoice->appendChild($invNumber);											
							$invoice->appendChild($invAmount);
							$invoice->appendChild($invDateTime);
							$invoice->appendChild($invCurrency);
							
							
							$root->appendChild($CashierBiller);
							$root->appendChild($patient);
							$root->appendChild($outbillTag);
							
							//deposits
							if(is_array($arrData['Deposits']) && count($arrData['Deposits']) > 0)
							{
								$depositsroot = $this->handle->createElement("Deposits");
								$dcounts = count($arrData['Deposits']);
								for($di=0;$di<$dcounts;$di++)
								{						
									$invdata = $arrData['Deposits'][$di];
												
									$invNumber = $this->handle->createElement("InvoiceNo");
									$invNumberText = $this->handle->createTextNode($invdata['InvoiceNo']);
									$invNumber->appendChild($invNumberText);
								
									$invCurrency = $this->handle->createElement("Currency");
									$invCurrencyText = $this->handle->createTextNode($invdata['DepositCurrency']);
									$invCurrency->appendChild($invCurrencyText);
									
									$invAmount= $this->handle->createElement("Amount");
									$invAmountText = $this->handle->createTextNode(number_format($invdata['DepositAmount'],2));
									$invAmount->appendChild($invAmountText);
									
									$invDateTime = $this->handle->createElement("DateTime");
									$invDateTimeText = @$this->handle->createTextNode($invdata['DepositTime']->format('d-m-Y H:i:s'));
									$invDateTime->appendChild($invDateTimeText);								
									
									$invoiceN = $this->handle->createElement("Deposit");
									$invoiceN->appendChild($invNumber);											
									$invoiceN->appendChild($invAmount);
									$invoiceN->appendChild($invDateTime);
									$invoiceN->appendChild($invCurrency);
									
									$depositsroot->appendChild($invoiceN);
								}
								
								$root->appendChild($depositsroot);
							}
							else{
								
								$deposit = $this->handle->createElement("Amount");						
								$depositText = $this->handle->createTextNode(number_format(0.00,2));
								$deposit->appendChild($depositText);
							
								$depositTag = $this->handle->createElement("Deposit");
								$depositTag->appendChild($deposit);
								$root->appendChild($depositTag);
							}
													
							
							
							//discounts
							
							if(is_array($arrData['Discounts']) && count($arrData['Discounts']) > 0)
							{
								$depositsroot = $this->handle->createElement("Discounts");
								$dcounts = count($arrData['Discounts']);
								for($di=0;$di<$dcounts;$di++)
								{								
									$invdata = $arrData['Discounts'][$di];
										
									$invNumber = $this->handle->createElement("ReferenceNo");
									$invNumberText = $this->handle->createTextNode($invdata['ReferenceNo']);
									$invNumber->appendChild($invNumberText);
								
									$invCurrency = $this->handle->createElement("Currency");
									$invCurrencyText = $this->handle->createTextNode($invdata['DepositCurrency']);
									$invCurrency->appendChild($invCurrencyText);
									
									$invAmount= $this->handle->createElement("Amount");
									$invAmountText = $this->handle->createTextNode(number_format($invdata['DiscountAmount'],2));
									$invAmount->appendChild($invAmountText);
									
									$invDateTime = $this->handle->createElement("DateTime");
									$invDateTimeText = $this->handle->createTextNode($invdata['DiscountTime']->format('d-m-Y H:i:s'));
									$invDateTime->appendChild($invDateTimeText);								
									
									$invoiceZ = $this->handle->createElement("Discount");
									$invoiceZ->appendChild($invNumber);											
									$invoiceZ->appendChild($invAmount);
									$invoiceZ->appendChild($invDateTime);
									$invoiceZ->appendChild($invCurrency);
									
									$depositsroot->appendChild($invoiceZ);
								}
								
								$root->appendChild($depositsroot);
							}
							
							
							$root->appendChild($invoice);		
							
							//services
							
							if(is_array($arrData['Services']) && count($arrData['Services']) > 0)
							{
								$depositsroot = $this->handle->createElement("Services");
								$dcounts = count($arrData['Services']);
								for($di=0;$di<$dcounts;$di++)
								{								
									$invdata = $arrData['Services'][$di];
										
									$Directorate = $this->handle->createElement("Directorate");
									$DirectorateText = $this->handle->createTextNode($invdata['Directorate']);
									$Directorate->appendChild($DirectorateText);
								
									$ServicePoint = $this->handle->createElement("ServicePoint");
									$ServicePointText = $this->handle->createTextNode($invdata['ServicePoint']);
									$ServicePoint->appendChild($ServicePointText);
									
									$ServicePlace= $this->handle->createElement("ServicePlace");
									$ServicePlaceText = $this->handle->createTextNode($invdata['ServicePlace']);
									$ServicePlace->appendChild($ServicePlaceText);
									
									$ServiceDescription = $this->handle->createElement("ServiceDescription");
									$ServiceDescriptionText = $this->handle->createTextNode($invdata['ServiceDescription']);
									$ServiceDescription->appendChild($ServiceDescriptionText);	
									
									$PaymentType = $this->handle->createElement("PaymentType");
									$PaymentTypeText = $this->handle->createTextNode($invdata['PaymentType']);
									$PaymentType->appendChild($PaymentTypeText);	
									
									
									$Amount= $this->handle->createElement("Amount");
									$AmountText = $this->handle->createTextNode(number_format($invdata['PaidAmt'],2));
									$Amount->appendChild($AmountText);							
									
									$Service = $this->handle->createElement("Service");
									$Service->appendChild($Directorate);											
									$Service->appendChild($ServicePoint);
									$Service->appendChild($ServicePlace);
									$Service->appendChild($ServiceDescription);
									$Service->appendChild($PaymentType);
									$Service->appendChild($Amount);
									
									$depositsroot->appendChild($Service);
								}
								
								$root->appendChild($depositsroot);
							}				
							
						}
						return TRUE;
					}
			}
			else
			{
				return NULL;
			}
		}
		else
		{
			return NULL;
		}
	}
	
	public function getXml($format=true)
	{
		$this->handle->formatOutput = $format;
		return $this->handle->saveXML();
	}
	public function getJson(){
		return $this->handle->saveJSON();
	}
	
	public function OutPutXML(){
		header('Content-Type: application/xml; charset=utf-8');
		print($this->getXml());
	}
	
  
}
?>